////////////////////////////////////////////////////////////////////////////////
//
// © 1999 – 2019 OneSpan North America Inc. All rights reserved.
// All rights reserved. https://www.onespan.com/
//
////////////////////////////////////////////////////////////////////////////////


/** an unknown error occurred */
static const int UNKNOWN_ERROR = -8000;

/** An error occurred during parsing of the command */
static const int COMMAND_PARSING_ERROR = -8001;

/** An error during activation occurred */
static const int ACTIVATION_ERROR = -8002;

/** An error during local authentication occurred */
static const int LOCAL_AUTHENTICATION_ERROR = -8003;

/** An error during local transaction occurred */
static const int LOCAL_TRANSACTION_ERROR = -8004;

/** An error during remote authentication occurred */
static const int REMOTE_AUTHENTICATION_ERROR = -8005;

/** An error during remote transaction occurred */
static const int REMOTE_TRANSACTION_ERROR = -8006;

static const int REMOTE_TRANSACTION_CALLBACK_NOT_SET_ERROR = -8029;

static const int REMOTE_AUTHENTICATION_CALLBACK_NOT_SET_ERROR = -8030;

/** An error during notification registration occurred */
static const int NOTIFICATION_REGISTRATION_ERROR = -8007;

/** An error happened during password change */
static const int CHANGE_PASSWORD_ERROR = -8008;

/** Indicates that the user ID is null or empty */
static const int USER_ID_NULL_OR_EMPTY = -8010;

/** Indicates that the user ID contains invalid characters, such as whitespaces */
static const int USER_ID_WRONG_FORMAT = -8011;

/** Indicates that the activation password is null or empty */
static const int ACTIVATION_PASSWORD_NULL_OR_EMPTY = -8012;

/** Indicates that the activation password has a wrong length */
static const int ACTIVATION_PASSWORD_WRONG_LENGTH = -8013;

/** Indicates that the activation password's checksum is not valid */
static const int ACTIVATION_PASSWORD_WRONG_CHECKSUM = -8014;

/** Indicates that the provided password is null */
static const int PASSWORD_NULL = -8015;

/** Indicates that the provided password is too short */
static const int PASSWORD_TOO_SHORT = -8016;

/** Indicates that the provided password is too long */
static const int PASSWORD_TOO_LONG = -8017;

/** Indicates that the provided password is weak (e.g 1111 or 1234) */
static const int PASSWORD_WEAK = -8018;

/** Indicates that the provided password is wrong */
static const int PASSWORD_WRONG = -8019;

/** Indicates that too many failed password attempts locked the DIGIPASS */
static const int PASSWORD_LOCK = -8020;

/** The camera permission is missing */
static const int MISSING_PERMISSION_CAMERA = -8021;

/** An error during an error response parsing occurred */
static const int ERROR_RESPONSE_ERROR = -8027;

/** Indicates that an invalid argument was passed */
static const int INVALID_ARGUMENT = -8028;

/** Indicates that an invalid argument was passed */
static const int WRONG_USER_AUTHENTICATION_METHOD_USED = -8029;

/** An internal error occured */
static const int INTERNAL_ERROR = -8999;
